
import oracle.xml.parser.schema.*;
import oracle.xml.parser.v2.*;
import oracle.xml.util.XMLUtil;
import java.net.*;
import java.io.*;
import org.w3c.dom.*;
import org.xml.sax.ContentHandler;
import java.util.*;

public class xsdsax
{
   public static void main(String[] args) throws Exception 
   {
      if (args.length != 2)
      {
         System.out.println("Usage: java xsdsax <schema_file> <xml_file>");
         return;
      }

      XSDBuilder builder = new XSDBuilder();
      URL    url =  XMLUtil.createURL(args[0]);

      // Build XML Schema Object
      XMLSchema schemadoc = (XMLSchema)builder.build(url);      
      process(args[1], schemadoc);
   }

   public static void process(String xmlURI, XMLSchema schemadoc)
   throws Exception 
   {
      SAXParser dp  = new SAXParser();
      URL       url = XMLUtil.createURL (xmlURI);
      
      dp.setPreserveWhitespace (true);
      dp.setValidationMode(XMLParser.NONVALIDATING);
      XMLError err;

      try 
      {
            err = new XMLError();
            XSDValidator validator = new XSDValidator();
            dp.setContentHandler(validator);
            validator.setError(err);
            validator.setXMLProperty(XSDNode.FIXED_SCHEMA, schemadoc);
            System.out.println("Parsing "+xmlURI);
            dp.parse (url);
      }
      catch (Exception e)
         {
            System.out.println ("Schema Validation Exception: " + e.getMessage());
            return;
         }
         if (err.getFirstError() >= -1)
            err.flushErrors();
      System.out.println("The input file <"+xmlURI+"> validated without errors");
   }
}

